#define TRUE 1
#define FALSE 0

#include <stdio.h>
#include <math.h>
#include <conio.h>
#include <ctype.h>

double raw_coefficients[1024], window_coefficients[1024], final_coefficients[2049];

double pi, low_frequency, high_frequency;
char  filter_type, type_selected = FALSE;
int   sample_frequency, cutoff_frequency,stop_band, coefficients, raw_size, odd_order_filter,fl, fh;
int   integer_coefficients[2049];
FILE  *outfile;

/*********************************************************

   REM  Bessi0  -  Returns in0, Modified Bessel function Io(x) for any real x.
   REM  From Press, et. al., Numerical Recepies in C, 2nd Ed. p237.

**********************************************************/

double bessi0(double value)
{
double abs_value, answer;
double y, a, b, c, d, e;

   abs_value = fabs(value);
   if ( abs_value < 3.75)
   {
       y = value / 3.75;
       y *= y;
       a = 0.0360768 + (y * 0.0045813);
       b = 0.2659732 + (y * a);
       c = 1.2067492 + (y * b);
       d = 3.0899424 + (y * c);
       e = 3.5156229 + (y * d);
       answer = (double) (1 + (y * e));
   }
   else
   {
       y = 3.75 / abs_value;
       a = y * (-0.016476330+ (y * 0.00392377));
       b = y * (-0.02057706 + (y* (0.02635537+a)));
       c = -0.157565e-2 + (y * (0.00916281 + b));
       d = y * (0.00225319 + (y* c));
       e = 0.39894228 + (y*(0.01328592+ d));
       answer = (exp(abs_value)/sqrt(abs_value)) * e;
   }
   return answer;
}
   
/*********************************************************

   This function calculates a one sided set of coefficients based on the 
   general form of a rectangular response of a general "bandpass" filter.

**********************************************************/
void calculate_coefficients(double low_frequency, double high_frequency)
{
int   i;
double filter_width, angle, normalized_angle, index;

   filter_width = high_frequency - low_frequency;
   if ( odd_order_filter)
   {
       raw_coefficients[0] = 2.0 * filter_width;
       i = 1;
   }
   else
   {
      i = 0;
   }

   for ( ; i < raw_size; i++)
   {
      if (odd_order_filter)
      {
         index = (double) i;
      }
      else
      {
         index = (double) i + 0.5;
      }
      
      angle = pi * index;
      // normalize the angle
      normalized_angle = angle * filter_width;
      // calculate the sine contribution
      raw_coefficients[i] = sin(normalized_angle) / angle;
      // calculate the cosine contribution
      raw_coefficients[i] = raw_coefficients[i] * 2.0 * cos(angle * (low_frequency + high_frequency));
   }
}

void adjust_coefficients(void)
{
double beta, x, bessel, beta_bessel, db, xi, xind;
int   i, j;

   db = (double) stop_band;
   //  REM Find beta, a parameter that determines the out-of-band attenuation.
   if ( db > 50)
   {
        beta = 0.1102 * (db - 8.7);
   }
   else if ( (db > 20.96) && (db <= 50))
   {
       beta = 0.58417 * pow((db - 20.96), 0.4);
       beta +=  0.07886 * (db - 20.96);
   }
   else
   {
      beta = 0.0;
   }
   // REM Find Kaiser window factors window_coefficients[j) that limit the out-of-band response.
   x = beta;
   beta_bessel = bessi0(x);

   xind = (double) ((coefficients - 1) * (coefficients - 1));
   for (i = 0; i < raw_size; i++)
   {
      if (odd_order_filter)
      {
         xi = (double)i;
      }
      else
      {
         xi = (double) i + 0.5;
      }
      xi = 4.0 * xi * xi;
      x = beta * sqrt(1.0 - (xi / xind));
      bessel = bessi0(x);
      window_coefficients[i] = bessel / beta_bessel;
   }
   
   // REM Window the ideal filter response:
   for (i=0; i < raw_size; i++)
   {
      raw_coefficients[i] *= window_coefficients[i];
   }
   
   // REM Rearrange to be causal filter coefficients:
   for (i=0; i< raw_size; i++)
   {
       final_coefficients[i] = raw_coefficients[raw_size - i -1];
   }
   if (odd_order_filter)
   {
      j = 1;
   }
   else
   {
      j = 0;
   }
   for (i=raw_size; i< coefficients; i++, j++)
   {
      final_coefficients[i] = raw_coefficients[j];
   }
}

void main(void)
{
int   i;
char  c;
   
   pi = 3.14159265359;
   printf("All numbers must be integers!\n");
   printf("Select from 8000, 16000, 24000, 48000, 96000, 192000\n");
   printf("What is the sample frequency? ");
   scanf_s ("%d", &sample_frequency);
   do
   {
      printf("\n");
      printf("Choices are 'L' for Low Pass, 'H' for High Pass, or 'B' for Band Pass\n");
      printf("Choose a filter type ");
      filter_type = _getch();
      printf("%c", toupper(filter_type));
      do
      {
        c = _getch();
      } while (c != '\r');
      printf("\n");
      switch (filter_type)
      {
         case 'L':
         case 'l':
         case 'H':
         case 'h':
            printf("What is the cutoff frequency? ");
            scanf_s("%d", &cutoff_frequency);
            type_selected = TRUE;
            break;
         case 'B':
         case 'b':
            printf("What is the lower cutoff frequency? ");
            scanf_s("%d", &fl);
            printf("What is the upper cutoff frequency? ");
            scanf_s("%d", &fh);
            type_selected = TRUE;
            break;
      }
   } while(type_selected == FALSE);
   
   printf("What is the stop band attenuation? ");
   scanf_s("%d", &stop_band);

   printf("How many coefficients do you want? (less than or equal to 2049) ");
   scanf_s("%d", &coefficients);
   
   switch (filter_type)
   {
      case 'L':
      case 'l':
         fl = 0;
         fh = cutoff_frequency;
         break;
      case 'H':
      case 'h':
         fl = cutoff_frequency;
         fh = sample_frequency/2;
         break;
   }
   low_frequency = (double)(fl) / (double)sample_frequency;
   high_frequency = (double)(fh) / (double)sample_frequency;
   
   if ((coefficients & 1) == 1)   
   {
      odd_order_filter = TRUE;
   }

   raw_size = coefficients / 2;
   if (odd_order_filter)
   {
      raw_size += 1;
   }
   // Calculate the raw coefficients
   calculate_coefficients(low_frequency, high_frequency);
   
   // Adjust the coefficients for a kaiser window
   adjust_coefficients();

   for (i=0; i < coefficients; i++)
   {
      integer_coefficients[i] = (int) (32767.9 * final_coefficients[i]);
   }
 
   outfile = fopen("filter_coefficients.c", "w");
   fprintf(outfile, "int number_of_coefficients = %d;\n", coefficients);
   fprintf(outfile, "long sample_rate = %d;\n", sample_frequency);
   fprintf(outfile, "int delay_buffer[%d];\n", (coefficients + 2));
   fprintf(outfile, "int coefficients[%d] = {\n", coefficients);
   for (i=0; i < (coefficients -1); i++)
   {
      fprintf(outfile, "          %d,\n", integer_coefficients[i]);
   }
   fprintf(outfile, "          %d };\n", integer_coefficients[i]);
   fclose(outfile);
}
   